<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/format" version="1.0">
<xsl:output method="xml" encoding="UTF-16" indent="yes"/>
	<xsl:template match="languages" >
		<languages>
			<xsl:apply-templates select="language"/>
		</languages>
	</xsl:template>
	<xsl:template match="language">
		<background>
			<name><xsl:value-of select="language_name"/></name>
			<xsl:copy-of select="date"/>
			<phylum>
				<xsl:choose>
					<xsl:when test="niger-congo='True'">Niger-Congo</xsl:when>
					<xsl:when test="nilo-saharan='True'">Nilo-Saharan</xsl:when>
					<xsl:when test="afro-asiatic='True'">Afro-Asiatic</xsl:when>
					<xsl:otherwise>other</xsl:otherwise>
				</xsl:choose>
			</phylum>
			<ethnologue_code/>
			<country/>
			<location/>
			<population/>
			<dialect/>
			<major_family><xsl:apply-templates select="family"/></major_family>
			<minor_family/>
			<source_description/>
			<source_coverage/>
			<xsl:apply-templates select="sources"/>
		</background>
	</xsl:template>

	<xsl:template match="sources">
		<sources><xsl:apply-templates select="source"/></sources>
	</xsl:template>

	<xsl:template match="source">
		<source><xsl:apply-templates/></source>
	</xsl:template>
</xsl:stylesheet>
